/**
 * Created by lei.wang_1 on 2016/11/15.
 */
appModule.controller('TaskInfoCtrl', ['$scope', 'utils', 'pages', 'api', 'notices', 'log', '$translate', function ($scope, utils, pages, api, notices, log, translate) {
    $scope.init = function () {
        var params = window.location.search;
        var id = utils.getUrlParam(params, 'id');
        pages.addWindowCloseListener($scope.onClose);
        $scope.getTaskBaseInfo(id);
    };

    $scope.getTaskBaseInfo = function (id) {
        api.getOneNotice(id, function (data) {
            utils.applyScope($scope, function () {
                var tempNotice = notices.notice.create();
                notices.notice.convertFromData(tempNotice, data);
                $scope.task = $.extend({}, tempNotice);
                $scope.task.selectedType = 'report';
                $scope.task.numberOfPeople = translate.instant('task.info.number-of-people', {number: $scope.task.unreadCount + $scope.task.readCount});
                $scope.members={};
                $scope.auditorNames = [];
                $scope.getSubTaskAuditorInfo($scope.task.ext_data.sub_task_list, function (info) {
                    utils.applyScope($scope, function () {
                        $scope.task.ext_data.sub_task_list.forEach(function (subTask) {
                            if (subTask.audit_user_id == info.userId) {
                                subTask.auditorName = info.displayName;
                                if ($scope.auditorNames.indexOf(info.displayName) < 0) {
                                    $scope.auditorNames.push(info.displayName);
                                }
                            }
                        });
                    });
                });
                pages.bindGlobalEvent('task_reply_update',$scope.TaskReplyUpdate);
            });
        }, function (msg, errorCode) {
            log.logInfo("failed to load notice " + $scope.task.id + "'s detail:" + msg);
            var option = {
                msg: msg,
                onConfirm: function () {
                    $scope.onClose();
                },
                onCancel: null,
                isShowCancel: false
            };
            api.notifyError(option);
        });
    };

    $scope.getSubTaskAuditorInfo = function (subTask, callback) {
        if (subTask && subTask.length > 0) {
            subTask.forEach(function (task) {
                if (task.audit_user_id) {
                    notices.getBasicUserInfo(task.audit_user_id, callback);
                }
            });
        }
    };

    $scope.canCancelTask = function (task) {
        return task.id && !task.is_close;
    };

    $scope.canShowFeedback = function (task) {
        return $scope.canCancelTask(task) && task.createTimestamp && task.createTimestamp <= Date.now();
    };

    $scope.showFeedback = function (task, subTaskId, e) {
        if (e) {
            e.stopPropagation();
        }
        if ($scope.canShowFeedback(task)) {
            var params = ['task_audit.html?'];
            if (!params) {
                return;
            }

            params.push('id=' + task.id);
            params.push('&sub_task_id=' + subTaskId);
            var url = params.join('');
            pages.openModalDialog(url, 'task audit', 1000, 660, $scope, {
                modal: false,
                caption: [{
                    left: 0,
                    top: 5,
                    width: 90,
                    height: 20
                }, {
                    left: 150,
                    top: 5,
                    width: -100,
                    height: 40
                }],
                resizable: false,
                refreshIfExist: true,
                enableDrag: false,
                behaviorIfSCClose: 4,
                showCloseButton: true,
                showMinimalButton: true,
                showFullScreenButton: true
            });
        }
    };

    $scope.toggleContent = function () {
        $scope.showContent = !$scope.showContent;
    };

    $scope.onTopClick = function (e) {
        if (!$(e.target).closest(".caption ")[0] && !$(e.target).closest(".taskContent")[0]) {
            $scope.showContent = false;
        }
    };

    $scope.toggleUserPanel = function () {
        utils.applyScope($scope, function () {
            $scope.isShowUserPanel = !$scope.isShowUserPanel;
        });
    };

    $scope.canSendReminder = function(){
       return $scope.task.ext_data.end_time_stamp == 0 || $scope.task.ext_data.end_time_stamp > Date.now() || $scope.task.ext_data.allow_expired;
    };

    $scope.sendReminder = function (hidePanel,callback) {
        api.sendFeedbackReminder($scope.task.id, function () {
            if (hidePanel) {
                $scope.toggleUserPanel();
            }
            if(callback){
                callback();
            }
        }, function (msg) {
            log.logInfo('fail to send reminder:' + msg);
        });
    };

    $scope.showUserPanel = function (count, type) {
        var status = 0;
        if (type == 'un-reply') {
            $scope.userPanelMessage = translate.instant('task.info.un-reply-count', {count: count});
            $scope.showReminderBtn = $scope.canSendReminder();
            status = -1;
        } else {
            $scope.userPanelMessage = translate.instant('task.info.all-executors-count', {count: count});
            $scope.showReminderBtn = false;
        }
        var userKey = type + '-user';
        if ($scope.members[userKey]) {
            $scope.users = $scope.members[userKey];
            $scope.toggleUserPanel();
            return;
        }
        api.getReplyUsers($scope.task.id, status, function (data) {
            $scope.users = data.map(function (item) {
                return {id: item};
            });
            $scope.members[userKey] = $.extend({}, $scope.users);
            $scope.toggleUserPanel();
        }, function (msg) {
            log.logInfo('fail to load un reply users.');
        });
    };

    $scope.changeTab = function(type){
        $scope.$broadcast('stopPlayingAudio');
        $scope.task.selectedType=type;
    };

    $scope.TaskReplyUpdate = function(data){
        utils.applyScope($scope,function(){
            $scope.members['un-reply-user']=null;
        });
        if($scope.task.id == data.detail.data.bbs_id){
            $scope.$broadcast('dataUpdate');
        }
    };
    
    $scope.onClose = function () {
        $scope.$destroy();
        utils.stopPlayMedia();
        pages.closeWindow();
    };
    
    $scope.init();



    $scope.$on('$destroy', function () {
        pages.unbindGlobalEvent('task_reply_update',$scope.TaskReplyUpdate);
        pages.removeWindowCloseListener();
    });
}]);
